<#ibiztemplate>
TARGET=PSAPPVIEWCTRL_GRID
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.vo;

import java.sql.Timestamp;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonProperty.Access;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.Data;
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.domain.${de.codeName};
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import org.springframework.cglib.beans.BeanMap;
import com.alibaba.fastjson.JSONObject;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ${de.codeName}_Grid_${ctrl.codeName}{
<#if ctrl.getPSDEGridDataItems()??>
<#list ctrl.getPSDEGridDataItems() as dataitem>
<#if de.getPSDEField(dataitem.name?lower_case,true)??>
    <#assign defitem=de.getPSDEField(dataitem.name?lower_case,true)>
    <#comment>实体属性</#comment>
    <#assign defDataType=defitem.getDataType()>
    <#assign dataType="${srfdatatype(defitem.getStdDataType())}"><#comment>外键值附加数据时间格式转换</#comment>
    <#if defDataType == "DATETIME" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defitem.getValueFormat()=="%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    <#elseif defDataType == "DATE" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defitem.getValueFormat()=="%1$tY-%1$tm-%1$td")>
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    <#elseif defDataType == "TIME" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defitem.getValueFormat()=="%1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="HH:mm", locale = "zh" , timezone="GMT+8")
    </#if>
    private ${srfjavatype(defitem.stdDataType)} ${dataitem.name?lower_case};
<#else>
    <#comment>系统保留属性 (srfmajortext)</#comment>
    <#if dataitem.name?lower_case='srfkey' || dataitem.name?lower_case='srfdataaccaction'>
    private ${srfjavatype(de.getKeyPSDEField().stdDataType)} ${dataitem.name?lower_case};
    <#elseif dataitem.name?lower_case='srfmajortext' >
    private ${srfjavatype(de.getMajorPSDEField().stdDataType)} ${dataitem.name?lower_case};
    <#else>
    private ${srfjavatype(dataitem.getDataType())} ${dataitem.name?lower_case};
    </#if>
</#if>
</#list>
    <#comment>表格修改</#comment>
    public void from${de.codeName}(${de.codeName} sourceEntity)  {
<#list ctrl.getPSDEGridDataItems() as dataitem>
    <#if dataitem.getDataItemParam()??>
        <#assign param0=dataitem.getDataItemParam()>
         this.set${dataitem.name?lower_case?cap_first}(sourceEntity.get${param0.getName()?lower_case?cap_first}());
	<#else>
        <#if de.getPSDEField(dataitem.name?lower_case,true)?? >
            <#assign  defield=dataitem.getPSDEField()>
            this.set${dataitem.name?lower_case?cap_first}(sourceEntity.get${defield.codeName?lower_case?cap_first}());
        </#if>
    </#if>
</#list>
	}
	public static Page<${de.codeName}_Grid_${ctrl.codeName}> from${de.codeName}(Page<${de.codeName}> sourcePage)  {
        if(sourcePage==null)
            return null;
        Page<${de.codeName}_Grid_${ctrl.codeName}> targetpage=new Page<${de.codeName}_Grid_${ctrl.codeName}>(sourcePage.getCurrent(),sourcePage.getSize(),sourcePage.getTotal(),sourcePage.isSearchCount());
        List<${de.codeName}_Grid_${ctrl.codeName}> records=new ArrayList<${de.codeName}_Grid_${ctrl.codeName}>();
        for(${de.codeName} source:sourcePage.getRecords()) {
            ${de.codeName}_Grid_${ctrl.codeName} target=new ${de.codeName}_Grid_${ctrl.codeName}();
            target.from${de.codeName}(source);
            records.add(target);
        }
        targetpage.setAsc(sourcePage.ascs());
        targetpage.setDesc(sourcePage.descs());
        targetpage.setOptimizeCountSql(sourcePage.optimizeCountSql());
        targetpage.setRecords(records);
        return targetpage;
    }
    /**
     * 表格模型集合
     * @return
     */
    public static List<Map<String,String>> getGridColumnModels() {
        List columnModelList =new ArrayList();
    <#list ctrl.getPSDEGridColumns() as gridColumn>
        <#if gridColumn.getPSDEField?? && gridColumn.getPSDEField()??>
        columnModelList.add(new HashMap(){ { put("${gridColumn.getPSDEField().getName()?lower_case}","${gridColumn.getCaption()}"); }});
        </#if>
    </#list>
        return columnModelList;
    }
    /**
     *将entity转成map
     * @param bean
     * @param <T>
     * @return
     */
    public <T> Map<String,Object> beanToMap(T bean){
        Map map =new HashMap<String,Object>();
        if(bean!=null){
            BeanMap beanMap=BeanMap.create(bean);
            for(Object obj:beanMap.keySet()){
                map.put(obj+"",beanMap.get(obj));
            }
        }
        return map;
    }
    /**
     * 将entity转成map
     * @param searchResult
     * @return
     */
    public static List<Map<String, Object>> pageToListDatas(Page<${de.codeName}> searchResult) {
        if(searchResult==null)
            return null;
        List<Map<String, Object>> records=new ArrayList<>();
        for(${de.codeName} source:searchResult.getRecords()) {
            ${de.codeName}_Grid_${ctrl.codeName} target=new ${de.codeName}_Grid_${ctrl.codeName}();
            records.add(target.beanToMap(source));
        }
        return records;
    }
    /**
     * 输出表格数据导出文件url
     * @param sourcePage
     * @param downloadurl
     * @return
     */
    public static Page<JSONObject> getResultPage(Page<${de.codeName}> sourcePage,String downloadurl)  {
        if(sourcePage==null)
            return null;
        Page<JSONObject> targetpage=new Page<JSONObject>(sourcePage.getCurrent(),sourcePage.getSize(),sourcePage.getTotal(),sourcePage.isSearchCount());
        List<JSONObject> records=new ArrayList<JSONObject>();
        JSONObject obj =new JSONObject();
        obj.put("downloadurl",downloadurl);
        records.add(obj);
        targetpage.setAsc(sourcePage.ascs());
        targetpage.setDesc(sourcePage.descs());
        targetpage.setOptimizeCountSql(sourcePage.optimizeCountSql());
        targetpage.setRecords(records);
        return targetpage;
    }
</#if>
}